// queryParameters -> handles the query string parameters
var queryParameters = {};

// queryString -> the query string without the fist '?' character
var queryString = location.search.substring( 1 );

// re -> the regular expression
var re = /([^&=]+)=([^&]*)/g;

// m-> holds the string matching the regular expression
var m;

// Creates a map with the query string parameters
while ( m = re.exec( queryString ) )
{
	queryParameters[ decodeURIComponent( m[ 1 ] ) ] = decodeURIComponent( m[ 2 ] );
}

function updateLinks( i, h )
{
	if ( h === undefined )
	{
		return h;
	}
	// Parse out any hash links to jump to places on the page
	var hash = this.hash;
	
	if ( hash === undefined )
	{
		hash = '';
	}

	// Remove hash from the URL
	h = h.replace( hash, '' );

	// Create params string
	var qsParams = jQuery.param( queryParameters );

	var uriParser = document.createElement('a');
	uriParser.href = h;

	// Keep URL looking OK if there's no params
	if ( qsParams != '' )
	{

		if ( h.charAt(h.length - 1) == '?'  )
		{
			h = h + qsParams;
		}
		else if ( uriParser.search != '' )
		{
			h = h + '&' + qsParams;
		}
		else
		{
			h = h + '?' + qsParams;
		}
	}

	// Readd on the hash
	h = h + hash;

	// Update the URL
	return h;
}


function getTomorrowDate( )
{
	var mydate = new Date();
	mydate.setDate(mydate.getDate()+1);

	var year=mydate.getYear()
	if (year < 1000)
	{
		year+=1900;
	}
	
	var day=mydate.getDay()
	var month=mydate.getMonth()
	var daym=mydate.getDate()
	
	if (daym<10)
	{
		daym="0" + daym;
	}
	var dayarray=new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado")
	var montharray=new Array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre")
	
	return dayarray[day] + ", " + daym + " " + montharray[month] + " " + year;
}

// Global function run to rewrite the query parameters
jQuery(document).ready(function () {
	jQuery("a").attr('href', function(i, h) { return updateLinks( i, h ); } );
	jQuery('#register_form').attr('action', function( i, h ) { return updateLinks( i, h ); } );
	jQuery(  '#sign_up_button' ).click( function() { //start function when Random button is clicked
		if (
			jQuery( '#result_user_name' ).hasClass( 'valid' ) &&
			jQuery( '#result_email' ).hasClass( 'valid' ) &&
			jQuery( '#result_mobile' ).hasClass( 'valid' ) &&
			jQuery( '#agreement' ).is( ':checked' )
		)
		{
			return true;
		}
		jQuery( '#result_agreement' ).html( "Please remember and fill in all the fields, and agree to the Terms and Conditions" ).show();
		return false;
	});

	jQuery( '#user_name' ).blur( function () {
		jQuery.ajax( {
			type: "post",
			url: ajax_object.url,
			data: {
				action: 'check_user_name',
				param: jQuery( this ).val()
			},
			beforeSend: function() { }, //fadeIn loading just when link is clicked
			success: function( data )
			{
				if ( data.status === 200 )
				{
					jQuery( '#result_user_name' ).removeClass( 'invalid' ).addClass( 'valid' );
				}
				else
				{
					jQuery( '#result_user_name' ).removeClass( 'valid' ).addClass( 'invalid' );
				}
				jQuery( '#result_user_name' ).html( data.response ).show();
			}
		});
		return false;
	});

	jQuery( '#email' ).blur( function () {
		jQuery.ajax( {
			type: "post",
			url: ajax_object.url,
			data: {
				action: 'check_email',
				param: jQuery( this ).val()
			},
			beforeSend: function() { }, //fadeIn loading just when link is clicked
			success: function( data )
			{
				if ( data.status === 200 )
				{
					jQuery( '#result_email' ).removeClass( 'invalid' ).addClass( 'valid' );
				}
				else
				{
					jQuery( '#result_email' ).removeClass( 'valid' ).addClass( 'invalid' );
				}
				jQuery( '#result_email' ).html( data.response ).removeClass( 'hide' ).show();
			}
		});
		return false;
	});

	jQuery( '#mobile' ).blur( function () {
		jQuery.ajax( {
			type: "post",
			url: ajax_object.url,
			data: {
				action: 'check_mobile',
				param: jQuery( this ).val()
			},
			beforeSend: function() { }, //fadeIn loading just when link is clicked
			success: function( data )
			{
				if ( data.status === 200 )
				{
					jQuery( '#result_mobile' ).removeClass( 'invalid' ).addClass( 'valid' );
				}
				else
				{
					jQuery( '#result_mobile' ).removeClass( 'valid' ).addClass( 'invalid' );
				}
				jQuery( '#result_mobile' ).html( data.response ).removeClass( 'hide' ).show();
			}
		});
		return false;
	});
});
